/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LockService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.logging.targets.LogrotateTarget;
import de.willuhn.logging.targets.OutputStreamTarget;
import de.willuhn.logging.targets.Target;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LogService
implements Bootable {
    public Class[] depends() {
        return new Class[]{LockService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        String lf = Application.getConfig().getLogFile();
        if (Application.inNonInteractiveMode()) {
            Logger.info((String)("running in non-interactive mode - logging to stdout disabled, check " + lf + " for logs"));
            try {
                Logger.flush();
            }
            catch (Exception exception) {}
        } else {
            Logger.addTarget((Target)new OutputStreamTarget((OutputStream)System.out));
        }
        Level level = Level.findByName((String)Application.getConfig().getLogLevel());
        if (level == null) {
            Logger.warn((String)"unable to detect defined log level, fallback to default level");
            level = Level.DEFAULT;
        }
        Logger.info((String)("using log level " + level.getName() + " [" + level.getValue() + "]"));
        Logger.setLevel((Level)level);
        try {
            Logger.info((String)("log file " + lf));
            File logFile = new File(lf);
            try {
                LogrotateTarget t = new LogrotateTarget(logFile, true);
                long size = Application.getConfig().getLogSize();
                Logger.info((String)("log size " + size + " bytes"));
                t.setMaxLength(size);
                Logger.addTarget((Target)t);
            }
            catch (IOException e) {
                Logger.error((String)"unable to use rotating log target, fallback to outputstream target", (Throwable)e);
                Logger.addTarget((Target)new OutputStreamTarget((OutputStream)new FileOutputStream(logFile, true)));
            }
        }
        catch (FileNotFoundException e) {
            Logger.error((String)"failed");
        }
        try {
            Class.forName("de.willuhn.logging.JavaLoggingHandler");
        }
        catch (Exception e) {
            Logger.error((String)"unable to redirect java logging", (Throwable)e);
        }
    }

    public void shutdown() {
    }
}

